	subroutine SOURCE(iout, idbg, Nn, Np, Ns, NnNd, &
			vY, rY, cY, lastY, Kappa, T, phi, Iyn)
! update reaction source
! NOTE: on the boundaries W = N by definition

	implicit none
	integer iout, idbg
	integer Nn, Np, Ns, NnNd		! array parameters
	integer lastY
	real*8 Kappa
	integer rY (Nn+1)			! global  arrays (compact rows)
	integer cY (NnNd)			! global  arrays (compact columns)
	real*8 vY (NnNd )			! global  arrays (compact values)
	real*8 T   (Nn,Ns)			! global  arrays
	real*8 phi(Nn)				! global  arrays
	real*8 Iyn(Nn,0:Np)			! convolution arrays for M*phi

	integer m, p				! local indices
	integer ii, jj				! global index
	real*8 aa, Iyns(Nn), src

!	write(idbg,'(a)') ' --- SOURCE ---'	! ### TEMPORARY ###

! calculate Iyns = sum on p of {Iyn}*Kappa
	if(Np .ne. 0)	then
! for EXP only
	  Iyns = 0.		! initialize Iyns; use matrix form
	  do ii = 1, Nn
	    do p = 0, Np
	      Iyns(ii) = Iyns(ii) + Iyn(ii,p)
	    enddo	! p
	  enddo		! ii
	endif

! volumetric term
!----------------
	do ii = 1, Nn
	  do jj = 1, Nn
	    aa = 0.
! access rank 2 sparse arrays
	    call ACCESS2(iout, idbg, Nn, NnNd, rY, cY, ii, jj, lastY, m)

	    if (m .ne. 0)	then
	      aa = vY(m)		! retrieve the Y (A for ADE,-A/tc for EXP)
	    endif

	    if(Np .eq. 0) then
! for ADE
	      src = -aa*Kappa*phi(jj)	! volumetric source term for ADE
	    else
! for EXP
	      src = aa*Kappa*Iyns(jj)	! volumetric source term for EXP
	    endif

! add volumetric term
	    T(ii,1) = T(ii,1) - src	! Ti - Kappa*Iyn*(Bij - Aij) for A
	    T(ii,2) = T(ii,2) - src	! Ti - Kappa*Iyn*(Bij - Aij) for B
	    T(ii,3) = T(ii,3) + src	! Ti + Kappa*Iyn*(Bij - Aij) for C
	  enddo		! jj
	enddo		! ii

	return
	end
